import pika
import json
from datetime import datetime
import sys
import logging_rpi
import BackhaulConfiguration
import time
import os

class Backhaul(object):
    def __init__(self, queueName, **kwargs):
        self.deviceID = BackhaulConfiguration.getSerial()
        self.IDFormat = BackhaulConfiguration.getIDFormat()
        self.LocalDateTimeFormat = BackhaulConfiguration.getLocalDateTimeFormat()
        self.UTCDateTimeFormat = BackhaulConfiguration.getUTCDateTimeFormat()

        self.pulsarLocation = 'ws://142.44.136.148:80/ws/v2/consumer/persistent/public/default/'
        self.queueName = queueName
        self.channel = None
        self.connection = None
        self.result = None

        self.jsonLimit = 785392
        self.dictListLimit = 6284
        self.directReply = kwargs.get("directReply", False)
        self.connectLocalhost()

    def connectLocalhost(self):
        self.connection = pika.BlockingConnection(pika.ConnectionParameters(host='localhost'))
        self.channel = self.connection.channel()
        self.channel.queue_declare(queue=self.queueName, durable=True)
        self.channel.confirm_delivery()
        logging_rpi.log.info("Backhaul Module:::connectLocalhost:::Successful")

    def send(self, data):
        #Don't use this. Thanks!
        retries = 0
        data['DirectReply'] = self.directReply
        data = json.dumps(data)

        def replyCallback(ch, method, properties, body):
            self.result =  body
            self.channel.stop_consuming()

        while True:
            try:
                if self.directReply:
                    self.result = None
                    self.channel.basic_consume('amq.rabbitmq.reply-to', replyCallback, auto_ack=True)
                    self.channel.basic_publish(
                        exchange='',
                        routing_key=self.queueName,
                        properties=pika.BasicProperties(
                            delivery_mode=2,  # make message persistent
                            reply_to='amq.rabbitmq.reply-to'
                        ),
                        body=data,
                        mandatory=True
                    )
                else:
                    self.result = None
                    self.channel.basic_publish(
                        exchange='',
                        routing_key=self.queueName,
                        properties=pika.BasicProperties(
                            delivery_mode=2  # make message persistent
                        ),
                        body=data,
                        mandatory=True
                    )
                self.channel.start_consuming()
                logging_rpi.log.info("Backhaul Module:::Pulsar Publish SUCCESS::: total retries taken: " + str(retries))

                return True

            except Exception as e:
                if retries > 2:
                    logging_rpi.log.error("Backhaul Module::: Pika Send Error:::" + str(e))
                    return False
                else:
                    retries += 1
                    self.connectLocalhost()
                    time.sleep(5)
                    logging_rpi.log.info("Backhaul Module:::Pulsar Publish FAILED::: current retries taken: " + str(retries))


    def sendData(self, topicName, data, **kwargs):

        debug = kwargs.get('debug', False)

        #Process json first
        
        try:
            data = json.loads(data)
            keys = data.keys()
            if self.IDFormat not in keys:
                data[self.IDFormat] = self.deviceID
            if self.UTCDateTimeFormat not in keys:
                data[self.UTCDateTimeFormat] = datetime.utcnow().strftime('%Y-%m-%d %H:%M:%S')
            if self.LocalDateTimeFormat not in keys:
                data[self.LocalDateTimeFormat] = datetime.now().strftime('%Y-%m-%d %H:%M:%S')
            
            package = {}
            package['Topic'] = topicName.lower()
            package['Data'] = data

        except Exception as e:
            logging_rpi.log.error("Backhaul Module:::Datatype Error:::"+str(e))
            return False

        try:
            if sys.getsizeof(data) > 785392:
                logging_rpi.log.error("Backhaul module:::send:::The size of the message is too large. Please send in batches.")
                return False
        except Exception as e:
            logging_rpi.log.error("Backhaul Module:::send:::Format likely wrong: "+str(e))
            return False

        try:
            #if debug mode is ON, print package's final state
            if debug:
                print package
                print "Sending to Queue Name: " + str(self.queueName)
                print "Total number of keys in Data: {0}".format(len(package['Data'].keys()))
            return self.send(package)
        except Exception as e:
            logging_rpi.log.error("Backhaul Module:::Pika Send Error:::"+str(e))
            return False

if __name__=='__main__':

    backhaul = Backhaul("publicQueue")

    datas = {}
    datas['Server'] = 'http://192.168.2.109'
    datas['CameraName'] = 'TestCamera'

    datas['Module'] = 'configurationmodule'
    datas['ConfigurationModule'] = 'softetherModule'

    datasJson = json.dumps(datas)
    print "Status:",

    print backhaul.sendData("generic-test-topic", datasJson)


